﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.IdentityModel.Tokens;
using System.Linq;
using Microsoft.IdentityModel.Tokens; 
using Microsoft.Owin.Security;
using Microsoft.Owin.Security.ActiveDirectory;
using Owin;

namespace PpmsDataWebService
{
    public partial class Startup
    {
        // For more information on configuring authentication, please visit https://go.microsoft.com/fwlink/?LinkId=301864

        public void ConfigureAuth(IAppBuilder app)
        {
            string connectionName = ConfigurationManager.AppSettings["ConnectionName"];
            string validAudience = "";
            switch (connectionName)
            {
                case "DEV":
                    validAudience = ConfigurationManager.AppSettings["NONPRODAudience"];
                    break;
                case "NON-PROD":
                    validAudience = ConfigurationManager.AppSettings["NONPRODAudience"];
                    break;
                case "PROD":
                    validAudience = ConfigurationManager.AppSettings["PRODAudience"];
                    break;
                default:
                    validAudience = ConfigurationManager.AppSettings["NONPRODAudience"];
                    break;
            }

            app.UseWindowsAzureActiveDirectoryBearerAuthentication(
                new WindowsAzureActiveDirectoryBearerAuthenticationOptions
                {
                    Tenant = ConfigurationManager.AppSettings["Tenant"],
                    TokenValidationParameters = new TokenValidationParameters {
                         ValidAudience = validAudience
                    },
                });
        }
    }
}
